<?php
namespace DROIT_ELEMENTOR_PRO;

use \Elementor\Controls_Stack;
use \Elementor\Core\DynamicTags\Dynamic_CSS;
use \Elementor\Core\Files\CSS\Post;
use \Elementor\Element_Base;
defined('ABSPATH') || die();
if (!class_exists('DL_Page_Scroll')) {
    class DL_Page_Scroll
    {
        private static $instance = null;
        public static function url(){
            if (defined('DROIT_EL_PRO_FILE')) {
                $file = trailingslashit(plugin_dir_url( DROIT_EL_PRO_FILE )). 'modules/page-scroll/';
            } else {
                $file = trailingslashit(plugin_dir_url( __FILE__ ));
            }
            return $file;
        }
    
        public static function dir(){
            if (defined('DROIT_EL_PRO_FILE')) {
                $file = trailingslashit(plugin_dir_path( DROIT_EL_PRO_FILE )). 'modules/page-scroll/';
            } else {
                $file = trailingslashit(plugin_dir_path( __FILE__ ));
            }
            return $file;
        }
    
        public static function version(){
            if( defined('DROIT_EL_PRO_VERSION') ){
                return DROIT_EL_PRO_VERSION;
            } else {
                return apply_filters('dladdons_pro_version', '1.0.0');
            }
            
        }
        public function init()
        {
            add_action( 'wp_enqueue_scripts', function() {       
                wp_enqueue_style( "dl-scrolling-css", self::url() . 'js/scrolling.css' , null, self::version() );       
                wp_enqueue_style( "dl-fullpage", self::url() . 'fullpage/fullpage.css' , null, self::version() );       
                wp_enqueue_script("dl-fullpage", self::url() . 'fullpage/fullpage.js', ['jquery'], self::version(), true);
                wp_enqueue_script("dl-scroll-overflow", self::url() . 'fullpage/scroll-overflow.js', ['jquery', 'dl-fullpage'], self::version(), true);
                wp_enqueue_script("dl-scrolling", self::url() . 'js/scrolling.min.js', ['jquery', 'dl-fullpage'], self::version(), true);
             } 
            );
            add_action( 'elementor/documents/register_controls', [$this, '_settings'] );
            add_action('elementor/element/section/section_layout/after_section_end', [$this, '_settings_page'], 999, 1);

            add_action('elementor/frontend/section/before_render', [ $this, '__add_content_render'], 1 );
        }
        public function _settings_page($element) {
            $post_id = get_the_ID();
            $page_settings_manager = \Elementor\Core\Settings\Manager::get_settings_managers( 'page' );
            $page_settings_model = $page_settings_manager->get_model( $post_id );
            $dl_onepage_enable = $page_settings_model->get_settings( 'dl_onepage_enable' );
            $id = $element->get_id();
            if ( 'section' === $element->get_name() && $dl_onepage_enable == 'yes') {
                $element->start_controls_section(
                    'dl_onepage_section',
                    [
                        'label' => __( 'One Page Scroll', 'saasland-core' ) . dl_get_icon() ,
                        'tab' => \Elementor\Controls_Manager::TAB_LAYOUT,
                        
                    ]
                );
         
                $element->add_control(
                    'dl_onepage_section_enable',
                    [
                        'label' => __( 'Enable Scroll', 'saasland-core' ),
                        'type' => \Elementor\Controls_Manager::SWITCHER,
                        'label_on' => __( 'Yes', 'saasland-core' ),
                        'label_off' => __( 'No', 'saasland-core' ),
                        'return_value' => 'yes',
                        'default' => 'no',
                    ]
                );
                $element->add_control(
                    'dl_onepage_anchor_id',
                    [
                        'label' => __( 'Anchor ID', 'saasland-core' ),
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'default' => '',
                        'placeholder' => 'section1',
                        'condition' => ['dl_onepage_section_enable' => 'yes']
                    ]
                );
                $element->add_control(
                    'dl_onepage_anchor_name',
                    [
                        'label' => __( 'Anchor Name', 'saasland-core' ),
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'default' => '',
                        'placeholder' => 'Section 1',
                        'condition' => ['dl_onepage_section_enable' => 'yes']
                    ]
                );
         
                $element->end_controls_section();
            }
        }
        public function _settings( $page  ){
            $settings = $page->get_settings_for_display();
          
            $page->start_controls_section(
                'dl_onepage_settings',
                [
                    'label' => __( 'Full Screen Slider Settings', 'saasland-core' ) . dl_get_icon(),
                    'tab' => \Elementor\Controls_Manager::TAB_SETTINGS,
                ]
            );
    
            $page->add_control(
                'dl_onepage_enable',
                [
                    'label' => __( 'Display Scroll', 'saasland-core' ),
                    'type' => \Elementor\Controls_Manager::SWITCHER,
                    'label_on' => __( 'On', 'saasland-core' ),
                    'label_off' => __( 'Off', 'saasland-core' ),
                    'return_value' => 'yes',
                    'default' => 'no',
                ]
            );
            $page->add_control(
                'dl_onepage_navi_enable',
                [
                    'label' => __( 'Display Navigation', 'saasland-core' ),
                    'type' => \Elementor\Controls_Manager::SWITCHER,
                    'label_on' => __( 'On', 'saasland-core' ),
                    'label_off' => __( 'Off', 'saasland-core' ),
                    'return_value' => 'yes',
                    'default' => 'no',
                ]
            );
            $page->add_control(
                'dl_onepage_navi_posi',
                [
                    'label' => __( 'Navigation Position', 'saasland-core' ),
                    'type' => \Elementor\Controls_Manager::SELECT,
                    'options' => [
                        'left' => __( 'Left', 'saasland-core' ),
                        'right' => __( 'Right', 'saasland-core' ),
                    ],
                    'condition' => ['dl_onepage_navi_enable' => 'yes']
                ]
            );
    
            $page->add_control(
                'dl_onepage_autoscroll',
                [
                    'label' => __( 'Auto Scroll', 'saasland-core' ),
                    'type' => \Elementor\Controls_Manager::SWITCHER,
                    'label_on' => __( 'On', 'saasland-core' ),
                    'label_off' => __( 'Off', 'saasland-core' ),
                    'return_value' => 'yes',
                    'default' => 'no',
                ]
            );
            $page->add_control(
                'dl_onepage_scrollbar',
                [
                    'label' => __( 'ScrollBar', 'saasland-core' ),
                    'type' => \Elementor\Controls_Manager::SWITCHER,
                    'label_on' => __( 'On', 'saasland-core' ),
                    'label_off' => __( 'Off', 'saasland-core' ),
                    'return_value' => 'yes',
                    'default' => 'no',
                ]
            );
            $page->add_control(
                'dl_onepage_overflow',
                [
                    'label' => __( 'Overflow Scroll', 'saasland-core' ),
                    'type' => \Elementor\Controls_Manager::SWITCHER,
                    'label_on' => __( 'On', 'saasland-core' ),
                    'label_off' => __( 'Off', 'saasland-core' ),
                    'return_value' => 'yes',
                    'default' => 'no',
                ]
            );
            $page->add_control(
                'dl_onepage_animation_anchor',
                [
                    'label' => __( 'Animate Anchor', 'saasland-core' ),
                    'type' => \Elementor\Controls_Manager::SWITCHER,
                    'label_on' => __( 'On', 'saasland-core' ),
                    'label_off' => __( 'Off', 'saasland-core' ),
                    'return_value' => 'yes',
                    'default' => 'no',
                ]
            );
            $page->add_control(
                'dl_onepage_animation_css3',
                [
                    'label' => __( 'Animate Css3', 'saasland-core' ),
                    'type' => \Elementor\Controls_Manager::SWITCHER,
                    'label_on' => __( 'On', 'saasland-core' ),
                    'label_off' => __( 'Off', 'saasland-core' ),
                    'return_value' => 'yes',
                    'default' => 'no',
                ]
            );
            $page->add_control(
                'dl_onepage_verticalcenter',
                [
                    'label' => __( 'Verticla Center', 'saasland-core' ),
                    'type' => \Elementor\Controls_Manager::SWITCHER,
                    'label_on' => __( 'On', 'saasland-core' ),
                    'label_off' => __( 'Off', 'saasland-core' ),
                    'return_value' => 'yes',
                    'default' => 'no',
                ]
            );
            $page->add_control(
                'dl_onepage_lazyLoading',
                [
                    'label' => __( 'LazyLoading', 'saasland-core' ),
                    'type' => \Elementor\Controls_Manager::SWITCHER,
                    'label_on' => __( 'On', 'saasland-core' ),
                    'label_off' => __( 'Off', 'saasland-core' ),
                    'return_value' => 'yes',
                    'default' => 'no',
                ]
            );
            $page->add_control(
                'dl_onepage_menu_heading',
                [
                    'label' => __( 'Menu options', 'saasland-core' ),
                    'type' => \Elementor\Controls_Manager::HEADING,
                    'separator' => 'before',
                ]
            );
            $page->add_control(
                'dl_onepage_menu_enable',
                [
                    'label' => __( 'Enable Menu', 'saasland-core' ),
                    'type' => \Elementor\Controls_Manager::SWITCHER,
                    'label_on' => __( 'On', 'saasland-core' ),
                    'label_off' => __( 'Off', 'saasland-core' ),
                    'return_value' => 'yes',
                    'default' => 'no',
                ]
            );
            $repeater = new \Elementor\Repeater();
            $repeater->add_control(
                'dlmenu_title', [
                    'label' => __( 'Title', 'saasland-core' ),
                    'type' => \Elementor\Controls_Manager::TEXT,
                    'default' => __( 'Menu Title' , 'saasland-core' ),
                    'label_block' => true,
                ]
            );
            $repeater->add_control(
                'dlmenu_id', [
                    'label' => __('Anchor ID', 'saasland-core' ),
                    'type' => \Elementor\Controls_Manager::TEXT,
                    'default' => '',
                    'placeholder' => 'section1',
                    'show_label' => true,
                ]
            );
            $repeater->add_control(
                'dlmenu_icon',
                [
                    'label' => __( 'Icon', 'saasland-core' ),
                    'type' => \Elementor\Controls_Manager::ICONS,
                ]
            );
            $page->add_control(
                'dl_onepage_menus',
                [
                    'label' => __( 'Menus', 'saasland-core' ),
                    'type' => \Elementor\Controls_Manager::REPEATER,
                    'fields' => $repeater->get_controls(),
                    'default' => [
                        [
                            'dlmenu_title' => __( 'Section 1', 'saasland-core' ),
                            'dlmenu_id' => 'section1',
                        ],
                       
                    ],
                    'title_field' => '{{{ dlmenu_title }}}',
                    'condition' => ['dl_onepage_menu_enable' => 'yes']
                ]
            );
    
            $page->add_control(
                'dl_onepage_toggle_heading',
                [
                    'label' => __( 'Preview & Next Button', 'saasland-core' ),
                    'type' => \Elementor\Controls_Manager::HEADING,
                    'separator' => 'before',
                ]
            );
            $page->add_control(
                'dl_onepage_toggle_preview', [
                    'label' => __( 'Preview Text', 'saasland-core' ),
                    'type' => \Elementor\Controls_Manager::TEXT,
                    'default' => __( 'Preview' , 'saasland-core' ),
                    'label_block' => true,
                ]
            );
            $page->add_control(
                'dl_onepage_toggle_next', [
                    'label' => __( 'Next Text', 'saasland-core' ),
                    'type' => \Elementor\Controls_Manager::TEXT,
                    'default' => __( 'Next' , 'saasland-core' ),
                    'label_block' => true,
                ]
            );
            $page->end_controls_section();
        }
        
        public function __add_content_render( Element_Base $el ){
            $post_id = get_the_ID();
            $page_settings_manager = \Elementor\Core\Settings\Manager::get_settings_managers( 'page' );
            $page_settings_model = $page_settings_manager->get_model( $post_id );
            $dl_onepage_enable = $page_settings_model->get_settings( 'dl_onepage_enable' );
            $settings = $el->get_settings_for_display();
            $id = $el->get_id();
            $sctionEnable = isset($settings['dl_onepage_section_enable']) ? $settings['dl_onepage_section_enable'] : 'no';
            $idAnchor = isset($settings['dl_onepage_anchor_id']) ? $settings['dl_onepage_anchor_id'] : $id;
            $nameAnchor = isset($settings['dl_onepage_anchor_name']) ? $settings['dl_onepage_anchor_name'] : 'Section 1';
            $idAnchor = empty($idAnchor) ? $id : $idAnchor;
            if ( 'section' === $el->get_name() &&  $dl_onepage_enable == 'yes' && $sctionEnable == 'yes') {
                $menuenable = $page_settings_model->get_settings( 'dl_onepage_menu_enable' );
                $menu = $page_settings_model->get_settings( 'dl_onepage_menus' );
                $navigation = $page_settings_model->get_settings( 'dl_onepage_navi_enable' );
                $navigationPosition = $page_settings_model->get_settings( 'dl_onepage_navi_posi' );
                $autoScrolling = $page_settings_model->get_settings( 'dl_onepage_autoscroll' );
                $scrollBar = $page_settings_model->get_settings( 'dl_onepage_scrollbar' );
                $scrollOverflow = $page_settings_model->get_settings( 'dl_onepage_overflow' );
                $animateAnchor = $page_settings_model->get_settings( 'dl_onepage_animation_anchor' );
                $css3 = $page_settings_model->get_settings( 'dl_onepage_animation_css3' );
                $verticalCentered = $page_settings_model->get_settings( 'dl_onepage_verticalcenter' );
                $lazyLoading = $page_settings_model->get_settings( 'dl_onepage_lazyLoading' );
                
                
                $settingsScroll['navigation'] = ($navigation == 'yes') ? true : false;
                $settingsScroll['navigationPosition'] = $navigationPosition;
                $settingsScroll['autoScrolling'] = ($autoScrolling == 'yes') ? true : false;
                $settingsScroll['scrollBar'] = ($scrollBar == 'yes') ? true : false;
                $settingsScroll['scrollOverflow'] = ($scrollOverflow == 'yes') ? true : false;
                $settingsScroll['animateAnchor'] = ($animateAnchor == 'yes') ? true : false;
                $settingsScroll['css3'] = ($css3 == 'yes') ? true : false;
                $settingsScroll['verticalCentered'] = ($verticalCentered == 'yes') ? true : false;
                $settingsScroll['lazyLoading'] = ($lazyLoading == 'yes') ? true : false;
               
                
                $attr['class'] = 'dl-section';
                if( $menuenable == 'yes'){
                    $attr['data-fp-styles'] = 'null';
                    $attr['data-anchor'] = $idAnchor;
                    $attr['data-dlmenus'] = wp_json_encode($menu);
                    $settingsScroll['menu'] = '#dlonpage-menu';
                }
                //$settingsScroll['afterResponsive'] = 'function (isResponsive) {}';
                //$settingsScroll['afterLoad'] = 'function (anchorLink, index) {}';
                $settingsScroll['sectionSelector'] = '.dl-section';
                $settingsScroll['slideSelector'] = '.dl-slide';
                $attr['data-onpage-scroll'] = wp_json_encode($settingsScroll);
                $preview = $page_settings_model->get_settings( 'dl_onepage_toggle_preview' );
                $next = $page_settings_model->get_settings( 'dl_onepage_toggle_next' );
                $attr['data-onpage-preview'] = $preview;
                $attr['data-onpage-next'] = $next;
                $attr['data-name'] = $nameAnchor;
                
                $el->add_render_attribute(
                    '_wrapper',
                    $attr
                );
            }
        }
        public static function instance(){
            if( is_null(self::$instance) ){
                self::$instance = new self();
            }
            return self::$instance;
        }
    }
}